import { defineStore } from "pinia";
import axios from "axios";
import { RelatedResources } from "../types";
import { useErrorHandling } from "@/modules/core/composables";

export const useResourcesRelatedArticlesStore = defineStore('resources-related-articles', {
    state: () => ({
        isBusy: true,
        articles: null as RelatedResources|null
    }),
    actions: {
        async getRelatedArticles(resource_id:string) {
            this.isBusy = true

            const request = axios.get<RelatedResources>(
                `/api/resources/related-resources`,
                {
                    params: {
                        resource_id: resource_id
                    }
                }
            )

            const response = await useErrorHandling(request);

            this.$patch({
                isBusy: false,
                articles: response.data
            })
        }
    }
})