export function openCenteredPopup (url: string, windowName: string, width: number, height: number) {
    const leftPosition = window.screenX + (window.innerWidth / 2) - (width / 2);
    const topPosition = window.screenY + (window.innerHeight / 2) - (height / 2);

    return window.open(
        url,
        windowName,
        `status=no,
        height=${height},
        width=${width},
        resizable=yes,
        left=${leftPosition},
        top=${topPosition},
        toolbar=no,
        menubar=no,
        scrollbars=no,
        location=no,
        directories=no`
    );
}

export function getTwitterShareUrl (url: string, text?: string) {
    const shareUrl = new URL(`https://x.com/intent/post`);
    shareUrl.searchParams.set('url', url);
    if (text) {
        shareUrl.searchParams.set('text', text);
    }
    return shareUrl.toString()
}

export function getFacebookSharerUrl (url: string) {
    return `https://www.facebook.com/sharer/sharer.php?u=${encodeURI(url)}`
}


export function getLinkedinShareUrl (url: string, text?: string) {
    const shareUrl = new URL('https://www.linkedin.com/sharing/share-offsite/');
    shareUrl.searchParams.set('url', encodeURI(url));
    if (text) {
        shareUrl.searchParams.set('text', text);
    }
    console.log('url:', url, 'text:', text)
    return shareUrl.toString()
}
