import type { PropType } from "vue";

type SupportedInputTypes = "email" | "hidden" | "number" | "password" | "search" | "tel" | "text" | "url";

export const commonFieldProps = {
    id: String,
    label: String,
    autocomplete: String,
    placeholder: String,
    type: {
        type: String as PropType<SupportedInputTypes>,
        default: "text"
    },
    value: String,
    disabled: Boolean,
    readonly: Boolean,
    maxlength: Number,
    required: Boolean,
    mandatory: Boolean,
    hint: String
}

export const commonSelectionFieldProps = {
    id: String,
    label: String,
    autocomplete: String,
    placeholder: String,
    value: String,
    disabled: Boolean,
    readonly: Boolean,
    required: Boolean,
    mandatory: Boolean,
    hint: String,
    itemText: String,
    itemValue: String,
    itemDisabled: String,
    items: Array as PropType<Array<any>>
}