import { scrollBy, scrollIntoView } from "seamless-scroll-polyfill";
// import scrollIntoView from 'smooth-scroll-into-view-if-needed';

export const scrollToEl = (el: HTMLElement|null, offset = 0) => {
    if (!el) return;
    scrollBy(window, {
        behavior: 'smooth',
        top: el.getBoundingClientRect().top - offset
    });
}

export const scrollToSelector = (el: string|null, offset = 0) => {
    if (!el) return;
    if(document.getElementById(el)) {
        scrollBy(window, {
            behavior: 'smooth',
            top: document.getElementById(el)!.getBoundingClientRect().top - offset
        });
    }
}

export const scrollToElPosition = (el: HTMLElement|null, top = 0) => {
    if (!el) return;
    scrollBy(window, {
        behavior: 'smooth',
        top
    });
}

export const scrollToTop = () => {
    scrollIntoView(document.body, { behavior: 'smooth' })
}


export const scrollToInvalidField = (el: HTMLElement|null = document.querySelector('.is-invalid')) => {
    if(!el) return;
    scrollIntoView(el, { behavior: 'smooth' });
}