// import { constants } from "../constants";
import { getLocale } from "./i18n";

export const kebabCase = (str: string) => {
    return str.replace(/([a-z])([A-Z])/g, "$1-$2").replace(/[\s_]+/g, '-').toLowerCase();
}

// export function formatAsCurrencyString (value?: number|null, currencyName = constants.DEFAULT_CURRENCY_CODE) {
//     if (typeof value === 'undefined' || value === null) return '';
//     const format = Intl.NumberFormat(
//         getLocale(),
//         {
//             currency: currencyName,
//             style: 'currency'
//         }
//     )
//     return format.format(value)
// }

export function formatNumberWithCommas(value?: number|null) {
    if (!value) return '';
    return Intl.NumberFormat(getLocale()).format(value);
}

const compactNumberFormatter = Intl.NumberFormat('en', { notation: 'compact' });

export const formatNumberCompact = (value?: number) => typeof value === 'undefined' ? '0' : compactNumberFormatter.format(value);

const standardNumberFormatter = Intl.NumberFormat('en', { notation: 'standard' });

export const formatNumber = (value?: number) => typeof value === 'undefined' ? '0' : standardNumberFormatter.format(value);