import { useErrorHandling } from "@/modules/core/composables";
import axios from "axios"
import { defineStore } from "pinia";
import { geoData } from "./types";

export const getWorldMapGeoJson = async () => {
    const request = axios.get<GeoJSON.GeoJSON>('/themes/custom/unsdg/frontend/public/geomap/UN_Geodata.geojson');

    const response = await useErrorHandling(request);
    
    return response.data;
}

export const useWorldMapGeoJsonStore = defineStore('geo-map', {
    state: () => ({
        isBusy: true,
        geoMapData: null as geoData|null
    }),
    getters: {
        getIso3Cd: (state) => {
            return (iso2cd: string) => {
                if (!state.geoMapData || !state.geoMapData.features) return null;

                const feature = state.geoMapData.features.find(
                    (feature: any) => feature.properties.iso2cd === iso2cd
                );

                return feature ? feature.properties.iso3cd : null;
            };
        }
    },
    actions: {
        async getGeoMapData() {
            this.isBusy = true;

            const request = axios.get<geoData>('/themes/custom/unsdg/frontend/public/geomap/UN_Geodata.geojson');

            const response = await useErrorHandling(request);

            this.$patch({
                isBusy: false,
                geoMapData: response.data
            })
        }
    }
})