export interface geoData {
    type: string;
    crs: CRSData;
    features: geoFeatures[];
}

export interface CRSData {
    type: string;
    properties: {
        name: string;
    };
}

export interface geoFeatures {
    type: string;
    id: number;
    geometry: GeometryData;
    properties: FeatureProperties;
}

export interface GeometryData {
    type: string;
    coordinates: Array<Array<[number, number]>>;
}

export interface Coordinate {
    lat: number;
    lng: number;
}

export interface FeatureProperties {
    objectid: number;
    iso3cd: string;
    m49_cd: string;
    nam_en: string;
    lbl_en: string;
    georeg: string;
    geo_cd: number;
    sub_cd: number;
    int_cd: number;
    subreg: string;
    intreg: string;
    iso2cd: string;
    lbl_fr: string;
    name_fr: string;
    globalid: string;
    stscod: number;
    isoclr: string;
}