import { getContactUsFormsSubmissions } from "@/api";
import { ContactUsFormsSubmission } from "@/typings/contactUsForms-submissions";
import { AsyncComputedOptions, computedAsync } from "@vueuse/core";
import { MaybeRef, unref, ref } from "vue";

export const useContactUsFormsSubmissionsAsync = (
    pageNumber: MaybeRef<number> = 1,
    pageSize: MaybeRef<number> = 10,
    options?: AsyncComputedOptions
) => {
    const isBusy = ref(false);

    const submissions = computedAsync<ContactUsFormsSubmission>(
        async (onCancel) => {
            isBusy.value = true;
            const abortController = new AbortController();

            onCancel(() => abortController.abort());

            try {
                return await getContactUsFormsSubmissions(
                    unref(pageNumber),
                    unref(pageSize),
                    abortController.signal
                );
            } finally {
                isBusy.value = false;
            }
        },
        undefined,
        options
    );

    return { submissions, isBusy };
};
