import { getCountrySdgProgress } from "@/api";
import { type AsyncComputedOptions, computedAsync } from "@vueuse/core";
import { unref, type MaybeRef } from "vue";

export const useCountrySdgProgressAsync = (
    countryCode: MaybeRef<string>,
    options?: AsyncComputedOptions
) => {
    return computedAsync(
        onCancel => {
            const abortController = new AbortController()

            onCancel(() => abortController.abort())

            return getCountrySdgProgress(unref(countryCode), abortController.signal)
        },
        [],
        options
    )
}