import { PrioritiesDataPoints } from "@/components/charts/types";

const tabColorMap = new Map([
    ['Top Performer', 'text-theme-ecoGreen border-theme-ecoGreen data-[state=active]:bg-theme-ecoGreen data-[state=active]:text-white'],
    ['Performer', 'text-theme-ecoGreen border-theme-ecoGreen data-[state=active]:bg-theme-ecoGreen data-[state=active]:text-white'],
    ['Performing', 'text-theme-ecoGreen border-theme-ecoGreen data-[state=active]:bg-theme-ecoGreen data-[state=active]:text-white'],
    ['Regressing', 'text-theme-red border-theme-red data-[state=active]:bg-theme-red data-[state=active]:text-white'],
    ['Stagnant', 'text-theme-cheerfulYellow border-theme-cheerfulYellow data-[state=active]:bg-theme-cheerfulYellow data-[state=active]:text-white'],
    ['Insufficient Data', 'text-theme-midGrey border-theme-lightGrey data-[state=active]:bg-theme-midGrey data-[state=active]:text-white'],
    ['NA', 'text-theme-midGrey2 border-theme-midGrey data-[state=active]:bg-theme-midGrey2 data-[state=active]:text-white'],
    ['Non-applicability', 'text-theme-midGrey2 border-theme-midGrey data-[state=active]:bg-theme-midGrey2 data-[state=active]:text-white'],
]);

export function getColorClass(categoryName: string) {
    if (!tabColorMap.get(categoryName)) {
        return 'text-theme-midGrey border-theme-lightGrey data-[state=active]:bg-theme-lightGrey data-[state=active]:text-black/70'
    }
    return tabColorMap.get(categoryName) || '';
};


const prioritiesStarIconMap = new Map([
    ['0', '/themes/custom/unsdg/frontend/public/images/star-0.svg'],
    ['1', '/themes/custom/unsdg/frontend/public/images/star-100.svg'],
]);

export function getPrioritiesStarIconUrl(starValue: string) {
    if (!prioritiesStarIconMap.get(starValue)) {
        return './themes/custom/unsdg/frontend/public/images/star-0.svg'; // Default image
    }

    return prioritiesStarIconMap.get(starValue);
};

const starLevelIconMap = new Map([
    ['1', '/themes/custom/unsdg/frontend/public/images/star-0.svg'],
    ['2', '/themes/custom/unsdg/frontend/public/images/star-25.svg'],
    ['3', '/themes/custom/unsdg/frontend/public/images/star-50.svg'],
    ['4', '/themes/custom/unsdg/frontend/public/images/star-75.svg'],
    ['5', '/themes/custom/unsdg/frontend/public/images/star-100.svg'],
]);

export function getStarLevelIconUrl(starLevelValue: string) {
    if (!starLevelIconMap.get(starLevelValue)) {
        return '/themes/custom/unsdg/frontend/public/images/star-0.svg'; // Default image
    }
    return starLevelIconMap.get(starLevelValue);
};

const trendIconMap = new Map([
    ['Top Performer', '/themes/custom/unsdg/frontend/public/images/green-up.svg'],
    ['Performer', '/themes/custom/unsdg/frontend/public/images/green-up.svg'],
    ['Performing', '/themes/custom/unsdg/frontend/public/images/green-up.svg'],
    ['Stagnant', '/themes/custom/unsdg/frontend/public/images/yellow-right-arrow.svg'],
    ['Regressing', '/themes/custom/unsdg/frontend/public/images/red-down-arrow.svg'],
    ['Insufficient Data', '/themes/custom/unsdg/frontend/public/images/insufficient.svg'],
    ['Not Applicable', '/themes/custom/unsdg/frontend/public/images/not-applicable.svg'],
]);

export function getTrendIconUrl(trendValue: string) {
    if (!trendIconMap.get(trendValue)) {
        return'/themes/custom/unsdg/frontend/public/images/not-applicable.svg'; // Default image
    }
    return trendIconMap.get(trendValue)
};

export function getFirstYearValue(arrayItems: Array<PrioritiesDataPoints>) {
    const { year, data_value } = arrayItems[0];
    const numericDataValue = parseFloat(data_value);
    return `${year} (${numericDataValue.toFixed(2)})`;
}

export function getLastYearValue(arrayItems: Array<PrioritiesDataPoints>) {
    const { year, data_value } = arrayItems[arrayItems.length - 1];
    const numericDataValue = parseFloat(data_value);
    return `${year} (${numericDataValue.toFixed(2)})`;
}

const chartLineColorMap = new Map([
    ['Top Performer', '#28b773'],
    ['Performing', '#28b773'],
    ['Performer', '#28b773'],
    ['Stagnant', '#facc15'],
    ['Regressing', '#f87171'],
    ['Insufficient Data', '#e5e7eb'],
    ['Non-applicability', '#7f7f7f'],
])

export function getChartLineColor(category: string) {
    if (!chartLineColorMap.get(category)) {
        return '#7f7f7f';
    }
    return chartLineColorMap.get(category)
}

const trendNameColorMap = new Map([
    ['Top Performer', 'text-[#28b773]'],
    ['Performing', 'text-[#28b773]'],
    ['Performer', 'text-[#28b773]'],
    ['Stagnant', 'text-[#facc15]'],
    ['Regressing', 'text-[#f87171]'],
    ['Insufficient Data', 'text-[#e5e7eb]'],
    ['Non-applicability', 'text-[#7f7f7f]'],
])

export function getChartTrendColor(category: string) {
    if (!trendNameColorMap.get(category)) {
        return 'text-primary'
    }
    return trendNameColorMap.get(category)
}

const nationalDataColorMap = new Map([
    ['Sufficient', 'text-theme-ecoGreen border-theme-ecoGreen data-[state=active]:bg-theme-ecoGreen data-[state=active]:text-white'],
    ['Insufficient', 'text-theme-midGreen border-theme-midGreen data-[state=active]:bg-theme-ecoGreen data-[state=active]:text-white'],
    ['No Data', 'text-theme-midGrey border-theme-lightGrey data-[state=active]:bg-theme-midGrey data-[state=active]:text-white'],
]);

export function getNationalDataColorMap(categoryName: string) {
    if (!nationalDataColorMap.get(categoryName)) {
        return 'text-theme-midGrey border-theme-lightGrey data-[state=active]:bg-theme-lightGrey data-[state=active]:text-black/70'
    }
    return nationalDataColorMap.get(categoryName) || '';
};

const nationalDataAreaColorMap = new Map([
    ['Sufficient', 'bg-theme-ecoGreen text-theme-darkGreen'],
    ['Insufficient', 'bg-theme-midGreen text-theme-ecoGreen'],
    ['No Data', 'bg-theme-lightGrey text-theme-midGrey'],
    ['Not Applicable', 'bg-theme-midGrey2 text-theme-darkerGrey'],
]);

export function getDataAvailabilityClass(areaCategory: string){
    if (!nationalDataAreaColorMap.get(areaCategory)) {
        return 'bg-theme-midGrey2 text-theme-darkerGrey'
    }
    return nationalDataAreaColorMap.get(areaCategory) || '';
}

