import Swiper from 'swiper';
import { Pagination } from 'swiper/modules';
import 'swiper/swiper-bundle.css';

import './styles.scss'

document.addEventListener('DOMContentLoaded', () => {
    const rootEls = document.querySelectorAll('.block-carousel-hero-banner .swiper-container');

    if (!rootEls.length) {
        return;
    }

    rootEls.forEach((carousel) => {
        const slides = carousel.querySelectorAll('.swiper-slide')
        const minSlidesRequired = 2

        new Swiper(carousel as HTMLElement, {
        modules: [Pagination],
        loop: slides.length >= minSlidesRequired,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true,
        },
        });
    });
});
