import { createApp, defineComponent, defineAsyncComponent, ref } from 'vue';

const initComponent = () => {
    const els = document.querySelectorAll('.block-countries-sdg-progress-tracker:not(.initialized)');

    if (els.length === 0) return;

    els.forEach(x => x.classList.add('initialized'))

    els.forEach(el => {
        const defaultCountry = el.getAttribute('data-default-country')

        const rootApp = createApp(
            defineComponent({
                components: {
                    ButtonBlock: defineAsyncComponent(() => import('@/components/ui/button/Button.vue')),
                    Tabs: defineAsyncComponent(() => import('@/components/ui/tabs/Tabs.vue')),
                    TabsContent: defineAsyncComponent(() => import('@/components/ui/tabs/TabsContent.vue')),
                    TabsList: defineAsyncComponent(() => import('@/components/ui/tabs/TabsList.vue')),
                    TabsTrigger: defineAsyncComponent(() => import('@/components/ui/tabs/TabsTrigger.vue')),
                    CountrySdgProgressTracker: defineAsyncComponent(() => import('./components/CountrySDGProgressTracker.vue'))
                },
                setup() {
                    const activeCountry = ref<string>(defaultCountry ?? '')
    
                    return {
                        activeCountry
                    }
                }
            })
        )

        rootApp.mount(el)
    })
}

initComponent()