import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
  const rootEls = document.querySelectorAll('.block-cta-button');

  if (!rootEls.length) {
    return;
  }

  for (const  [index, rootEl] of rootEls.entries()) {
    const app = createApp(
      defineComponent({
        components: {
            ButtonBlock: defineAsyncComponent(() => import('@/components/ui/button/Button.vue')),
        },
      })
    );

    rootEl.setAttribute('id', `block-cta-button-${index}`);

    app.mount(`#${rootEl.id}`);
  }
};

initComponent();




