import Swiper from 'swiper';
import { Pagination } from 'swiper/modules';
import 'swiper/swiper-bundle.css';

import './styles.scss'

document.addEventListener('DOMContentLoaded', () => {
    const rootEls = document.querySelectorAll('.block-testimonials .swiper-container');

    if (!rootEls.length) {
        return;
    }

    rootEls.forEach((carousel) => {
        new Swiper(carousel as HTMLElement, {
        modules: [Pagination],
        loop: true,
        slidesPerView: 2.3,
        spaceBetween: 16,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true,
        },
        });
    });
});
