import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
    const rootEl = document.querySelector('.menu-footer');

    if (!rootEl) return;

    const app = createApp(
        defineComponent({
            components: {
                ContactUsForm: defineAsyncComponent(() => import('@/components/contact-us-form/ContactUsForm.vue')),
                Accordion: defineAsyncComponent(() => import('@/components/ui/accordion/Accordion.vue')),
                AccordionItem: defineAsyncComponent(() => import('@/components/ui/accordion/AccordionItem.vue')),
                AccordionTrigger: defineAsyncComponent(() => import('@/components/ui/accordion/AccordionTrigger.vue')),
                AccordionContent: defineAsyncComponent(() => import('@/components/ui/accordion/AccordionContent.vue')),
            },
        })
    );

    app.mount(rootEl);
};

initComponent();




