import { createApp, defineComponent, defineAsyncComponent } from 'vue';
const initComponent = async () => {
  const rootEls = document.querySelectorAll('.goals-dashboard-chart');

  if (!rootEls.length) {
    return;
  }

  for (const  [index, rootEl] of rootEls.entries()) {
    const app = createApp(
      defineComponent({
        components: {
            GoalsDashboardChart: defineAsyncComponent(() => import('@/components/charts/regional-analysis-dashboard/GoalsDashboardChart.vue')),
            SnapshotChart: defineAsyncComponent(() => import('@/components/charts/regional-analysis-snapshot/SnapshotChart.vue')),
        },
      })
    );

    rootEl.setAttribute('id', `goals-dashboard-chart-${index}`);

    app.mount(`#${rootEl.id}`);
  }
};

initComponent();




