import { createPinia } from 'pinia';
import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
    const rootEl = document.querySelector('.national-analysis');

    if (!rootEl) return;

    const app = createApp(
        defineComponent({
            components: {
                NationalDropdown: defineAsyncComponent(() => import('@/components/analysis-dropdowns/NationalDropdown.vue')),
                NationalOverviewChart: defineAsyncComponent(() => import('@/components/charts/national-analysis-overview/NationalOverviewChart.vue')),
                NationalPrioritiesChart: defineAsyncComponent(() => import('@/components/charts/national-analysis-priorities/NationalPrioritiesChart.vue')),
                NationalDataChart: defineAsyncComponent(() => import('@/components/charts/national-analysis-data/NationalDataAvailabilityChart.vue')),
                Tabs: defineAsyncComponent(() => import('@/components/ui/tabs/Tabs.vue')),
                TabsContent: defineAsyncComponent(() => import('@/components/ui/tabs/TabsContent.vue')),
                TabsList: defineAsyncComponent(() => import('@/components/ui/tabs/TabsList.vue')),
                TabsTrigger: defineAsyncComponent(() => import('@/components/ui/tabs/TabsTrigger.vue')),
                Select: defineAsyncComponent(() => import('@/components/ui/select/Select.vue')),
                SelectContent: defineAsyncComponent(() => import('@/components/ui/select/SelectContent.vue')),
                SelectGroup: defineAsyncComponent(() => import('@/components/ui/select/SelectGroup.vue')),
                SelectLabel: defineAsyncComponent(() => import('@/components/ui/select/SelectLabel.vue')),
                SelectItem: defineAsyncComponent(() => import('@/components/ui/select/SelectItem.vue')),
                SelectTrigger: defineAsyncComponent(() => import('@/components/ui/select/SelectTrigger.vue')),
                SelectValue: defineAsyncComponent(() => import('@/components/ui/select/SelectValue.vue')),
                AnalysisCtaSection: defineAsyncComponent(() => import('@/components/AnalysisCtaSection.vue')),
                TabWrapper: defineAsyncComponent(() => import('@/components/regional-analysis/TabWrapper.vue')),
            },
        })
    );

    const pinia = createPinia();
    
    app.use(pinia);
    app.mount(rootEl);
};

document.addEventListener('DOMContentLoaded', () => {
    initComponent();
})




