import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
    const rootEl = document.querySelector('.main-navigation-menu') as HTMLElement;

    if (!rootEl) return;

    const handleScroll = () => {
        const scrollY = window.scrollY;
        const offsetTop = rootEl.offsetTop;

        if (scrollY > offsetTop) {
            rootEl.classList.add('sticky-nav');
        } else {
            rootEl.classList.remove('sticky-nav');
        }
    };

    window.addEventListener('scroll', handleScroll);

    const app = createApp(
        defineComponent({
            components: {
                HoverCard: defineAsyncComponent(() => import('@/components/ui/hover-card/HoverCard.vue')),
                HoverCardTrigger: defineAsyncComponent(() => import('@/components/ui/hover-card/HoverCardTrigger.vue')),
                HoverCardContent: defineAsyncComponent(() => import('@/components/ui/hover-card/HoverCardContent.vue')),
                AlertDialog: defineAsyncComponent(() => import('@/components/ui/alert-dialog/AlertDialog.vue')),
                AlertDialogCancel: defineAsyncComponent(() => import('@/components/ui/alert-dialog/AlertDialogCancel.vue')),
                AlertDialogContent: defineAsyncComponent(() => import('@/components/ui/alert-dialog/AlertDialogContent.vue')),
                AlertDialogTrigger: defineAsyncComponent(() => import('@/components/ui/alert-dialog/AlertDialogTrigger.vue')),
                Accordion: defineAsyncComponent(() => import('@/components/ui/accordion/Accordion.vue')), 
                AccordionContent: defineAsyncComponent(() => import('@/components/ui/accordion/AccordionContent.vue')),
                AccordionItem: defineAsyncComponent(() => import('@/components/ui/accordion/AccordionItem.vue')),
                AccordionTrigger: defineAsyncComponent(() => import('@/components/ui/accordion/AccordionTrigger.vue')),
            },
        })
    );

    app.mount(rootEl);
};

initComponent();




