import { createApp, defineComponent, defineAsyncComponent } from 'vue';
import { createPinia } from 'pinia';

const initComponent = async () => {
    const rootEl = document.querySelector('.regional-analysis');

    if (!rootEl) return;

    const app = createApp(
        defineComponent({
            components: {
                Tabs: defineAsyncComponent(() => import('@/components/ui/tabs/Tabs.vue')),
                TabsContent: defineAsyncComponent(() => import('@/components/ui/tabs/TabsContent.vue')),
                TabsList: defineAsyncComponent(() => import('@/components/ui/tabs/TabsList.vue')),
                TabsTrigger: defineAsyncComponent(() => import('@/components/ui/tabs/TabsTrigger.vue')),
                SelectAnalysis: defineAsyncComponent(() => import('@/components/ui/select/Select.vue')),
                SelectContent: defineAsyncComponent(() => import('@/components/ui/select/SelectContent.vue')),
                SelectGroup: defineAsyncComponent(() => import('@/components/ui/select/SelectGroup.vue')),
                SelectLabel: defineAsyncComponent(() => import('@/components/ui/select/SelectLabel.vue')),
                SelectItem: defineAsyncComponent(() => import('@/components/ui/select/SelectItem.vue')),
                SelectTrigger: defineAsyncComponent(() => import('@/components/ui/select/SelectTrigger.vue')),
                SelectValue: defineAsyncComponent(() => import('@/components/ui/select/SelectValue.vue')),
                GoalsDashboardChart: defineAsyncComponent(() => import('@/components/charts/regional-analysis-dashboard/GoalsDashboardChart.vue')),
                SnapshotChart: defineAsyncComponent(() => import('@/components/charts/regional-analysis-snapshot/SnapshotChart.vue')),
                DataAvailabilityChart: defineAsyncComponent(() => import('@/components/charts/regional-analysis-data/DataAvailabilityChart.vue')),
                DataOverviewChart: defineAsyncComponent(() => import('@/components/charts/regional-analysis-data/DataOverviewChart.vue')),
                RegionalDropdown: defineAsyncComponent(() => import('@/components/analysis-dropdowns/RegionalDropdown.vue')),
                AnalysisCtaSection: defineAsyncComponent(() => import('@/components/AnalysisCtaSection.vue')),
                TabWrapper: defineAsyncComponent(() => import('@/components/regional-analysis/TabWrapper.vue')),
            },
        })
    );

    const pinia = createPinia();
    
    app.use(pinia);
    app.mount(rootEl);
};

document.addEventListener('DOMContentLoaded', () => {
    initComponent();
})



