import { createPinia } from 'pinia';
import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
    const rootEl = document.querySelector('.resources-page');

    if (!rootEl) return;

    const app = createApp(
        defineComponent({
            components: {
                ResourcesListing: defineAsyncComponent(() => import('@/components/resources/ResourcesListing.vue')),
                ToggleGroup: defineAsyncComponent(() => import('@/components/ui/toggle-group/ToggleGroup.vue')),
                ToggleGroupItem: defineAsyncComponent(() => import('@/components/ui/toggle-group/ToggleGroupItem.vue')),
                ResourcesRelatedArticles: defineAsyncComponent(() => import('@/components/resources/ResourcesRelatedArticles.vue')),
                ShareIcons: defineAsyncComponent(() => import('@/components/social-sharing/SocialSharing.vue')),
            },
        })
    );

    const pinia = createPinia();
    
    app.use(pinia);
    app.mount(rootEl);
};

document.addEventListener('DOMContentLoaded', () => {
    initComponent();
})