import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
  const rootEls = document.querySelectorAll('.unsdg-tabs');

  if (!rootEls.length) {
    return;
  }

  for (const  [index, rootEl] of rootEls.entries()) {
    const app = createApp(
      defineComponent({
        components: {
            Tabs: defineAsyncComponent(() => import('@/components/ui/tabs/Tabs.vue')),
            TabsContent: defineAsyncComponent(() => import('@/components/ui/tabs/TabsContent.vue')),
            TabsList: defineAsyncComponent(() => import('@/components/ui/tabs/TabsList.vue')),
            TabsTrigger: defineAsyncComponent(() => import('@/components/ui/tabs/TabsTrigger.vue')),
        },
      })
    );

    rootEl.setAttribute('id', `unsdg-tabs-${index}`);

    app.mount(`#${rootEl.id}`);
  }
};

initComponent();