import { createPinia } from 'pinia';
import { createApp, defineComponent, defineAsyncComponent } from 'vue';

const initComponent = async () => {
    const rootEl = document.querySelector('.use-case-page');

    if (!rootEl) return;

    const app = createApp(
        defineComponent({
            components: {
                ShareIcons: defineAsyncComponent(() => import('@/components/social-sharing/SocialSharing.vue')),
                RelatedUseCases: defineAsyncComponent(() => import('@/components/epic-use-case/RelatedUseCases.vue'))
            },
        })
    );

    const pinia = createPinia();
    
    app.use(pinia);
    app.mount(rootEl);
};

document.addEventListener('DOMContentLoaded', () => {
    initComponent();
})