export interface BaseContent{
    id: number;
    name: string;
    key: string;
    typeAlias?: string;
}

export interface BaseMedia extends BaseContent {
    url: string;
    width: number;
    height: number;
}

export interface BaseElement<T = void> {
    key: string;
    ncContentTypeAlias: T & string;
}

export interface BaseUser {
    id: number;
    name: string;
    email: string;
}

export interface PickedColor {
    color: string;
    label: string;
}