const animate = require("tailwindcss-animate")
const defaultTheme = require('tailwindcss/defaultTheme')

/** @type {import('tailwindcss').Config} */
module.exports = {
    darkMode: ["class"],
    content: [
        './pages/**/*.{ts,tsx,vue}',
        './components/**/*.{ts,tsx,vue}',
        './app/**/*.{ts,tsx,vue}',
        './src/**/*.{ts,tsx,vue}',
        '../templates/**/*.twig'
    ],
    safelist: [
        'bg-theme-lightBlue',
        'bg-theme-cheerfulYellow',
        'bg-theme-red',
        'bg-theme-lightGrey',
        'text-theme-lightBlue',
        'text-theme-cheerfulYellow',
        'text-theme-red',
        'text-theme-lightGrey',
        'border-theme-lightBlue',
        'border-theme-cheerfulYellow',
        'border-theme-red',
        'border-theme-lightGrey',
        'bg-transparent',
        'hidden',
    ],
    prefix: "",
    theme: {
        container: {
            center: true,
            padding: "18px",
        },
        extend: {
            fontFamily: {
                sans: ['Roboto', ...defaultTheme.fontFamily.sans],
                serif: ['Roboto Slab', ...defaultTheme.fontFamily.serif]
            },
            colors: {
                'theme': {
                    blueSky: '#0068B8',
                    ecoGreen: '#28B773',
                    midGreen: '#AEDDC7',
                    darkGreen: '#1B7D4E',
                    brightBlue: '#F2F7FB',
                    lightBlue: '#E6F0F8',
                    darkBlue: '#020B3B',
                    lightGrey: '#E8E8E8',
                    midGrey: '#B1B1B1',
                    midGrey2: '#7F7F7F',
                    darkerGrey: '#3F3F3F',
                    cheerfulYellow: '#FFBE0B',
                    darkYellow: '#AD830D',
                    red: '#FF674C',
                    darkRed: '#B42910',
                }
            },
            spacing: {
                '18p': '1.125rem',
                '50p': '3.125rem',
                '52p': '3.25rem',
                '60p': '3.75rem',
                '100p': '6.25rem',
                '106p': '6.625rem'
            },
            listStyleImage: {
                rightArrow: 'url("/themes/custom/unsdg/frontend/public/images/chevron-right.svg")',
            },
            keyframes: {
                "accordion-down": {
                    from: { height: 0 },
                    to: { height: "var(--radix-accordion-content-height)" },
                },
                "accordion-up": {
                    from: { height: "var(--radix-accordion-content-height)" },
                    to: { height: 0 },
                },
            },
            animation: {
                "accordion-down": "accordion-down 0.2s ease-out",
                "accordion-up": "accordion-up 0.2s ease-out",
            },
            gridTemplateColumns: {
                '2-auto-1fr': 'auto 1fr',
                '4-auto-1fr': 'repeat(2, auto 1fr)',
                '8-auto-1fr': 'repeat(4, auto 1fr)',
                'test': 'auto 1fr auto 1fr',
            }
        }
    },
    plugins: [
        animate,
        require('@tailwindcss/typography'),
        require('@tailwindcss/forms'),
        require('tailwind-scrollbar'),
        function ({ addVariant }) {
            addVariant("v-cloak", "&[v-cloak]");
        },
    ]
}