import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import mkcert from'vite-plugin-mkcert'
import path from "path"

import tailwind from "tailwindcss"
import autoprefixer from "autoprefixer"

export default defineConfig(({command}) => {
  return {
    server:{
      origin: 'https://localhost:5173',
      port: 5173,
    },
    base: command === 'serve' ? '/' : '/themes/custom/unsdg/frontend/dist',
    plugins: [vue(), mkcert()],
    resolve: {
      alias: {
        "@": path.resolve(__dirname, "./src"),
        vue: 'vue/dist/vue.esm-bundler.js',
      },
    },
    css: {
      postcss: {
        plugins: [tailwind(), autoprefixer()],
      },
    },
    build: {
      manifest: true,
      rollupOptions: {
        input: {
          client: path.resolve(__dirname, './src/main.ts'),
          backoffice: path.resolve(__dirname, './src/backoffice.ts'),
        }
      },
    },
  }
})
